# -*- coding: utf-8 -*-
import os
import sys
import getopt


def proc_path(dest_path, full_mode=True):

    # 读取指定目录下文件名列表，创建字典fn_dict
    fn_dict = {}
    filelist = os.listdir(dest_path)
    for filename in filelist:
        if filename not in ['FileNames.exe', 'FileNames-s.exe', 'FileNames-S.exe',
                            'FileNames.py', 'FileNames-s.py', 'FileNames-S.py'] \
                and os.path.isfile(os.path.join(dest_path, filename)):
            if full_mode:
                fn_dict[filename] = ''
            else:
                fn, ext = os.path.splitext(filename)
                if fn in fn_dict:
                    dup_ext = fn_dict.pop(fn)
                    fn_dict[fn + dup_ext] = ''
                    fn_dict[filename] = ''
                else:
                    fn_dict[fn] = ext

    # 判断操作类型
    if 'FileNames.txt' in filelist:
        print('---- Rename Files ----')

        f = open(os.path.join(dest_path, 'FileNames.txt'), 'r', encoding='utf8')
        lines = f.readlines()
        f.close()

        for line in lines:
            line = line.replace('\n', '')
            n = line.find('\t')
            if n < 0:
                n = line.find(';')
            if n < 0:
                n = line.find(',')
            if n > 0:
                filename_old = line[0:n].strip()
                filename_new = line[n+1:].strip()
                if filename_old != filename_new and filename_old in fn_dict.keys():
                    os.rename(os.path.join(dest_path, filename_old + fn_dict[filename_old]),
                              os.path.join(dest_path, filename_new + fn_dict[filename_old]))

    else:
        print('---- List Files ----')

        f = open(os.path.join(dest_path, 'FileNames.txt'), 'w', encoding='utf8')
        f.write('\n'.join(fn_dict.keys()))
        f.close()

    print('\nFinished!\n')


if __name__ == '__main__':
    opts, argv = getopt.getopt(sys.argv[1:], 'sSfF')

    # 根据程序文件名设置默认文件名模式
    fn, ext = os.path.splitext(sys.argv[0])
    full_mode = False if len(fn) > 2 and fn[len(fn)-2:].lower() == '-s' else True

    # 检查输入参数：文件名模式
    if len(opts) > 0:
        full_mode = False if opts[0][0].lower() == '-s' else True

    input_path = os.getcwd() if len(argv) == 0 else argv[0]
    print('\nList or Rename Files in:\n\t%s\n' % input_path)

    if os.path.isdir(input_path):
        proc_path(input_path, full_mode)
    else:
        print('It is NOT a directory!')
